/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.comp.RolloverToggleButton;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.print.LogoPrinter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JDialog {
    protected Pageable fPageable;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_previewContainer;
    protected PagePreview m_previewPage;
    protected JTextField fStatusline;
    protected JComboBox fComboBox;
    protected JButton fForwardButton;
    protected JButton fBackwardButton;
    protected JScrollPane fScrollPane = null;
    private RolloverToggleButton btZoomIn;
    private RolloverToggleButton btZoomOut;
    protected static double NORMAL_ZOOM = 1.0;
    protected Editor fEditor;

    private PrintPreview(JFrame parent) {
        super(parent);
    }

    private PrintPreview(JDialog parent) {
        super(parent);
    }

    public static PrintPreview create(Editor editor, Pageable pageable, String title) {
        Window window = editor.getApplicationSurface().getWindow();
        PrintPreview printPreview = null;
        if (window instanceof JFrame) {
            printPreview = new PrintPreview((JFrame)window);
        } else if (window instanceof JDialog) {
            printPreview = new PrintPreview((JDialog)window);
        } else {
            throw new IllegalArgumentException("A PrintPreview can only be created with a JDialog or JFrameas parent.");
        }
        printPreview.setTitle(title);
        printPreview.setEditor(editor);
        printPreview.setPageable(pageable);
        printPreview.initComponents();
        return printPreview;
    }

    private void initComponents() {
        this.setModal(true);
        this.setVisible(false);
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.fBackwardButton = new JButton(Language.getString("dialog.printPreview.back", "Back"));
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.m_previewPage.decPageIndex();
                PrintPreview.this.fComboBox.setSelectedIndex(PrintPreview.this.fComboBox.getSelectedIndex() - 1);
                PrintPreview.this.updatePageSelection();
            }
        };
        this.fBackwardButton.addActionListener(lst);
        this.fBackwardButton.setAlignmentY(0.5f);
        this.fBackwardButton.setMargin(new Insets(2, 6, 2, 6));
        this.fBackwardButton.setEnabled(false);
        tb.add(this.fBackwardButton);
        this.fForwardButton = new JButton(Language.getString("dialog.printPreview.forward", "Forward"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.m_previewPage.incPageIndex();
                PrintPreview.this.fComboBox.setSelectedIndex(PrintPreview.this.fComboBox.getSelectedIndex() + 1);
                PrintPreview.this.updatePageSelection();
            }
        };
        this.fForwardButton.addActionListener(lst);
        this.fForwardButton.setAlignmentY(0.5f);
        this.fForwardButton.setMargin(new Insets(2, 6, 2, 6));
        tb.add(this.fForwardButton);
        this.fComboBox = new JComboBox();
        Dimension d = this.fComboBox.getPreferredSize();
        this.fComboBox.setMinimumSize(new Dimension(40, d.height));
        this.fComboBox.setPreferredSize(new Dimension(40, d.height));
        this.fillPagesComboBox();
        ItemListener ilst = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String str = (String)PrintPreview.this.fComboBox.getSelectedItem();
                    int scale = 0;
                    try {
                        scale = Integer.parseInt(str);
                        PrintPreview.this.m_previewPage.setPageIndex(scale - 1);
                        PrintPreview.this.updatePageSelection();
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                }
            }
        };
        this.fComboBox.addItemListener(ilst);
        this.fComboBox.setMaximumSize(this.fComboBox.getPreferredSize());
        this.fComboBox.setEditable(false);
        tb.addSeparator();
        tb.add(this.fComboBox);
        tb.addSeparator();
        this.btZoomOut = new RolloverToggleButton(Global.getIcon("ZoomOut.gif"));
        this.btZoomOut.setSelected(false);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.btZoomIn.setSelected(false);
                PrintPreview.this.btZoomOut.setSelected(true);
                PrintPreview.this.changeZoom(new Point(0, 0));
                PrintPreview.this.setZoomCursor();
            }
        };
        this.btZoomOut.addActionListener(lst);
        tb.add(this.btZoomOut);
        this.btZoomIn = new RolloverToggleButton(Global.getIcon("ZoomIn.gif"));
        this.btZoomIn.setSelected(true);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.btZoomOut.setSelected(false);
                PrintPreview.this.btZoomIn.setSelected(true);
                PrintPreview.this.changeZoom(new Point(0, 0));
                PrintPreview.this.setZoomCursor();
            }
        };
        this.btZoomIn.addActionListener(lst);
        tb.add(this.btZoomIn);
        tb.addSeparator();
        JLabel percentLabel = new JLabel(Language.getString("dialog.printPreview.percent", "Percent:"));
        this.m_cbScale = new JComboBox();
        Dimension scaleSize = this.m_cbScale.getPreferredSize();
        this.m_cbScale.setMinimumSize(new Dimension(60, scaleSize.height));
        this.m_cbScale.setPreferredSize(new Dimension(60, scaleSize.height));
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.fillScalesComboBox();
        ItemListener scalelst = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String str = (String)PrintPreview.this.m_cbScale.getSelectedItem();
                    double scale = Double.valueOf(str.replace("%", "")) / 100.0;
                    PrintPreview.this.changeZoom(scale);
                    PrintPreview.this.setZoomCursor();
                }
            }
        };
        this.m_cbScale.addItemListener(scalelst);
        this.m_cbScale.setEditable(false);
        tb.add(percentLabel);
        tb.add(this.m_cbScale);
        tb.addSeparator();
        JButton bt = new JButton(Language.getString("dialog.printPreview.print", "Print"), Global.getIcon("Print.gif"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.print();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        bt = new JButton(Language.getString("dialog.printPreview.properties", "Properties"));
        bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintPreview.this.setupPrintOptions();
            }
        });
        tb.addSeparator();
        tb.add(bt);
        bt = new JButton(Language.getString("dialog.printPreview.close", "Close"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.addSeparator();
        tb.add(bt);
        this.getContentPane().add((Component)tb, "North");
        this.fStatusline = new JTextField();
        this.fStatusline.setEditable(false);
        this.fStatusline.setBackground(UIManager.getColor("Panel.background"));
        this.getContentPane().add((Component)this.fStatusline, "South");
        this.m_previewPage = new PagePreview(0);
        this.m_previewContainer = new PreviewContainer();
        this.m_previewContainer.addMouseListener(new PageMouseAdapter());
        this.m_previewContainer.add(this.m_previewPage);
        this.fScrollPane = new JScrollPane(this.m_previewContainer);
        JScrollBar scrollBar = this.fScrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(16);
        scrollBar = this.fScrollPane.getHorizontalScrollBar();
        scrollBar.setUnitIncrement(16);
        this.getContentPane().add((Component)this.fScrollPane, "Center");
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.updatePageSelection();
        this.setVisible(true);
    }

    private void notifyLayoutScrolls() {
        if (this.m_previewContainer != null) {
            this.m_previewContainer.invalidate();
        }
        if (this.fScrollPane != null) {
            this.fScrollPane.validate();
        }
        this.invalidate();
        this.updateUI();
    }

    public void changeZoom(Point p) {
        if (!this.btZoomIn.isSelected() && !this.btZoomOut.isSelected()) {
            return;
        }
        double zoom = this.m_previewPage.getZoom();
        if (this.btZoomIn.isSelected() && zoom == 4.0) {
            return;
        }
        p.x = (int)((double)p.x / zoom);
        p.y = (int)((double)p.y / zoom);
        boolean zoomIn = this.btZoomIn.isSelected();
        if (zoomIn) {
            this.m_previewPage.increaseZoom();
        } else {
            this.m_previewPage.decreseZoom();
        }
        zoom = this.m_previewPage.getZoom();
        this.m_cbScale.setSelectedItem(String.valueOf((int)(zoom * 100.0)) + "%");
        p.x = (int)((double)p.x * zoom);
        p.y = (int)((double)p.y * zoom);
        this.notifyLayoutScrolls();
        int maximum = this.fScrollPane.getVerticalScrollBar().getMaximum();
        int visibleAmount = this.fScrollPane.getVerticalScrollBar().getVisibleAmount();
        int position = Math.max(1, p.y - (int)((double)visibleAmount * 0.5));
        position = Math.min(position, maximum - visibleAmount);
        this.fScrollPane.getVerticalScrollBar().setValue(position);
        maximum = this.fScrollPane.getHorizontalScrollBar().getMaximum();
        visibleAmount = this.fScrollPane.getHorizontalScrollBar().getVisibleAmount();
        position = Math.max(1, p.x - (int)((double)visibleAmount * 0.5));
        position = Math.min(position, maximum - visibleAmount);
        this.fScrollPane.getHorizontalScrollBar().setValue(position);
    }

    public void changeZoom(double newzoom) {
        double zoom = this.m_previewPage.getZoom();
        if (newzoom == zoom) {
            return;
        }
        if (newzoom > zoom) {
            this.btZoomIn.setSelected(true);
            this.btZoomOut.setSelected(false);
        } else {
            this.btZoomOut.setSelected(true);
            this.btZoomIn.setSelected(false);
        }
        this.m_previewPage.setZoom(newzoom);
        this.notifyLayoutScrolls();
    }

    public void updatePageSelection() {
        if (this.m_previewPage.getPageIndex() >= this.fPageable.getNumberOfPages() - 1) {
            this.fForwardButton.setEnabled(false);
        } else {
            this.fForwardButton.setEnabled(true);
        }
        if (this.m_previewPage.getPageIndex() <= 0) {
            this.fBackwardButton.setEnabled(false);
        } else {
            this.fBackwardButton.setEnabled(true);
        }
        this.notifyLayoutScrolls();
    }

    protected void fillPagesComboBox() {
        int previewPagesCount = this.fPageable.getNumberOfPages();
        String[] scales = new String[previewPagesCount];
        for (int i = 1; i <= previewPagesCount; ++i) {
            scales[i - 1] = new String(Integer.toString(i));
        }
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>(scales);
        this.fComboBox.setModel(dcbm);
        this.fComboBox.setVisible(previewPagesCount > 1);
        this.fComboBox.invalidate();
        if (this.fComboBox.getParent() != null) {
            this.fComboBox.getParent().validate();
        }
    }

    protected void fillScalesComboBox() {
        String[] scales = new String[16];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = String.valueOf(25 * (i + 1)) + "%";
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(scales);
        this.m_cbScale.setModel(model);
        this.m_cbScale.invalidate();
        this.m_cbScale.setSelectedItem("100%");
        if (this.m_cbScale.getParent() != null) {
            this.m_cbScale.getParent().validate();
        }
    }

    public void print() {
        PrinterJob printJob = LogoPrinter.getPrinterJob();
        printJob.setPageable(this.fPageable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setupPrintOptions() {
        LogoPrinter lp = new LogoPrinter((LogoComfort)this.fEditor);
        lp.showPrintScopeDialog();
        this.fPageable = lp.getBook();
        this.fillPagesComboBox();
        this.m_previewPage.setPageIndex(0);
        this.updatePageSelection();
    }

    protected void setZoomCursor() {
        Cursor cursor = null;
        if (this.btZoomOut.isSelected()) {
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(Global.getImage("ZoomOutCursor.gif"), new Point(1, 1), "ZoomOutCursor");
        } else if (this.btZoomIn.isSelected()) {
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(Global.getImage("ZoomInCursor.gif"), new Point(1, 1), "ZoomInCursor");
        }
        this.m_previewContainer.setCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        this.setZoomCursor();
        PrintPreview printPreview = this;
        synchronized (printPreview) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(Math.max(0, bounds.x + (bounds.width - abounds.width) / 2), Math.max(0, bounds.y + (bounds.height - abounds.height) / 2));
        }
        super.show();
    }

    public void updateUI() {
        String status = Language.getString("dialog.printPreview.page", "Page:") + " " + (this.m_previewPage.getPageIndex() + 1) + "/" + this.fPageable.getNumberOfPages() + "\t\t  " + Language.getString("dialog.printPreview.zoom", "Zoom") + ": " + (int)(this.m_previewPage.getZoom() * 100.0) + "%";
        this.fStatusline.setText(status);
        if (this.fComboBox != null) {
            this.fComboBox.setSelectedIndex(this.m_previewPage.getPageIndex());
        }
        this.repaint();
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    public void setEditor(Editor editor) {
        this.fEditor = editor;
    }

    public Pageable getPageable() {
        return this.fPageable;
    }

    public void setPageable(Pageable pageable) {
        this.fPageable = pageable;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PageMouseAdapter
    extends MouseAdapter {
        PageMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            PrintPreview.this.changeZoom(e.getPoint());
        }
    }

    class PagePreview
    extends JPanel {
        protected int fPageIndex;
        protected double m_zoom = 1.0;
        private static final double MIN_ZOOM = 0.25;
        private static final double MAX_ZOOM = 4.0;
        private static final double ZOOM_INCREMENT = 0.25;

        public PagePreview(int pageIndex) {
            this.fPageIndex = pageIndex;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public Dimension getPreferredSize() {
            if (this.getPageIndex() == -1) {
                return new Dimension(0, 0);
            }
            PageFormat pf = PrintPreview.this.fPageable.getPageFormat(this.getPageIndex());
            return new Dimension((int)(pf.getWidth() * this.getZoom()), (int)(pf.getHeight() * this.getZoom()));
        }

        public void incPageIndex() {
            this.setPageIndex(this.getPageIndex() + 1);
            this.invalidate();
            this.getParent().validate();
        }

        public void decPageIndex() {
            this.setPageIndex(this.getPageIndex() - 1);
            this.invalidate();
            this.getParent().validate();
        }

        public int getPageIndex() {
            this.fPageIndex = Math.min(this.fPageIndex, PrintPreview.this.fPageable.getNumberOfPages() - 1);
            return this.fPageIndex;
        }

        public void setPageIndex(int newIndex) {
            this.fPageIndex = newIndex;
            this.invalidate();
            this.getParent().validate();
        }

        public void decreseZoom() {
            this.m_zoom -= 0.25;
            if (this.m_zoom < 0.25) {
                this.m_zoom = 0.25;
            }
        }

        public void increaseZoom() {
            this.m_zoom += 0.25;
            if (this.m_zoom > 4.0) {
                this.m_zoom = 4.0;
            }
        }

        public double getZoom() {
            return this.m_zoom;
        }

        public void setZoom(double m_zoom) {
            if (m_zoom > 4.0) {
                m_zoom = 4.0;
            } else if (m_zoom < 0.25) {
                m_zoom = 0.25;
            } else {
                this.m_zoom = m_zoom;
            }
        }

        public void paint(Graphics g) {
            int pageIndex = this.getPageIndex();
            if (pageIndex == -1) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintBorder(g2);
            g2.scale(this.m_zoom, this.m_zoom);
            try {
                PrintPreview.this.fPageable.getPrintable(pageIndex).print(g2, PrintPreview.this.fPageable.getPageFormat(pageIndex), pageIndex);
            }
            catch (PrinterException pe) {
                System.out.println("PrintException aufgetreten");
            }
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            int w = (int)PrintPreview.this.m_previewPage.getPreferredSize().getWidth();
            int h = (int)PrintPreview.this.m_previewPage.getPreferredSize().getHeight();
            Insets ins = this.getInsets();
            return new Dimension(w + ins.left + ins.right + this.H_GAP, h + ins.top + ins.bottom + this.V_GAP);
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

